/* Antarmuka dengan Sensor DHT11 - Trainer Internet of Things
 * Project : Monitoring Suhu dan Kelembaban Udara
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library LCD 16x2 I2C
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
// Library DHT11
#include <DHT.h>

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN DHT Terhubung ke PIN D5 NodeMCU
#define DHT_PIN  D5

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// LCD objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);
// DHT objek dengan nama dht
DHT dht(DHT_PIN, DHT11);

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data suhu dan kelembaban
float t, h;

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200); 
  dht.begin();
  
  lcd.init();          // Inisialisasi LCD
  lcd.backlight();     // Menyalakan Backlight LCD
  
  // Menampilkan Teks pada LCD
  lcd.setCursor(0,0); lcd.print("Trainer Kit IoT");  
  lcd.setCursor(0,1); lcd.print("Connecting-WiFi");
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD
}

void loop() {
  // Membaca suhu dan kelembaban udara
  // Data disimpan pada masing-masing variabel
  t = dht.readTemperature(); // Membaca suhu dalam Celsius
  h = dht.readHumidity();    // Membaca kelembaban Udara
  // Periksa pembacaan jika gagal akan diulangi
  if(isnan(t) || isnan(h)) {
    Serial.println("Tidak dapat membaca sensor DHT11!");
    return;
  }
  // Set nilai menjadi 0 jika data isnan
  if(isnan(t)) t=0;
  if(isnan(h)) h=0;

  // Mencetak data suhu dan kelembaban pada serial monitor
  Serial.println("Temp:" + String(t) + " °C");
  Serial.println("Humd:" + String(h) + " %");
  Serial.println();

  // Mengirim data suhu ke database *user/gauge1
  // Mengirim data kelemababan ke database *user/gauge2
  Firebase.setFloat(fbdo, "/" + user + "/gauge1", t);
  Firebase.setFloat(fbdo, "/" + user + "/gauge2", h);

  // Menampilkan data suhu pada LCD
  lcd.setCursor(0,0); 
  lcd.print("Temp: " + String(t) + char(223) + "C");
  
  // Menampilkan data kelembaban pada LCD
  lcd.setCursor(0,1); 
  lcd.print("Humd: " + String(h) + " %");
}
